#include "mainwindow.h"
#include "calculating.h"
#include "fileview.h"
#include <qdir.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qthread.h>

using namespace std;

MainWindow::MainWindow(QWidget *w) : QMainWindow(w) {
  setupUi(this);
  setMinimumSize(size());
  setMaximumSize(size());
  about = new AboutWindow(0);
  connect(computeBtn, SIGNAL(clicked()), this, SLOT(compute()));
  connect(workspaceBtn, SIGNAL(clicked()), this, SLOT(showWorkspace()));
  connect(guideBtn, SIGNAL(clicked()), this, SLOT(showGuide()));
  connect(aboutBtn, SIGNAL(clicked()), about, SLOT(show()));
  connect(inputExtensionsBtn, SIGNAL(clicked()), this,
          SLOT(select_input_extensions_file()));
  connect(goodVertBtn, SIGNAL(clicked()), this, SLOT(select_good_vert_file()));
  connect(eGraphBtn, SIGNAL(clicked()), this, SLOT(select_e_graph_file()));
  connect(goodSetsBtn, SIGNAL(clicked()), this, SLOT(select_good_sets_file()));
  connect(maxExtBtn, SIGNAL(clicked()), this, SLOT(select_max_ext_file()));
  connect(inputCliquesBtn, SIGNAL(clicked()), this,
          SLOT(select_input_cliques_file()));
  connect(outputCliquesBtn, SIGNAL(clicked()), this,
          SLOT(select_output_cliques_file()));
  connect(inputIsomorphismBtn, SIGNAL(clicked()), this,
          SLOT(select_input_isomorphism_file()));
  connect(outputIsomorphismBtn, SIGNAL(clicked()), this,
          SLOT(select_output_isomorphism_file()));
  connect(goodVertViewBtn, SIGNAL(clicked()), this, SLOT(view_goodvert()));
  connect(eGraphViewBtn, SIGNAL(clicked()), this, SLOT(view_egraph()));
  connect(goodSetsViewBtn, SIGNAL(clicked()), this, SLOT(view_goodsets()));
  connect(maxExtViewBtn, SIGNAL(clicked()), this, SLOT(view_maxext()));
  connect(cliquesViewBtn, SIGNAL(clicked()), this, SLOT(view_cliques()));
  connect(classesViewBtn, SIGNAL(clicked()), this, SLOT(view_classes()));
  check();
}

void MainWindow::compute() {
  int tabIndex = tabWidget->currentIndex();

  switch (tabIndex) {
  case 0:
    maximal_extensions();
    break;

  case 1:
    maximal_cliques();
    break;

  default:
    isomorphism_classes();
  }
}

void MainWindow::showWorkspace() {
  QFileDialog *dialog = new QFileDialog(this, "Workspace", "workspace");

  dialog->setWindowFlags(dialog->windowFlags() &
                         ~Qt::WindowContextHelpButtonHint);
  dialog->setViewMode(QFileDialog::Detail);
  dialog->setWindowIcon(windowIcon());
  dialog->show();
}

void MainWindow::showGuide() { new GuideView; }

#define EXACT_NAME(x, y)                                                       \
  ((QString("workspace/") + x + "/" + (y->text())).toStdString().data())

void MainWindow::maximal_extensions() {
  new extensions_window(EXACT_NAME("extensions", inputExtensionsEdt),
                        EXACT_NAME("extensions", goodVertEdt),
                        EXACT_NAME("extensions", eGraphEdt),
                        EXACT_NAME("extensions", goodSetsEdt),
                        EXACT_NAME("extensions", maxExtEdt));
}

void MainWindow::maximal_cliques() {
  new cliques_window(EXACT_NAME("cliques", inputCliquesEdt),
                     EXACT_NAME("cliques", outputCliquesEdt));
}

void MainWindow::isomorphism_classes() {
  new isomorphism_window(EXACT_NAME("isomorphisms", inputIsomorphismEdt),
                         EXACT_NAME("isomorphisms", outputIsomorphismEdt));
}

void MainWindow::choose_file(QLineEdit *edt, QString caption, QString dir,
                             bool output) {
  QDir graph_dir(QString("workspace/") + dir);
  QString filename;

  dir = QString("workspace/") + dir;

  caption += " File";

  if (output)
    filename = QFileDialog::getSaveFileName(0, caption, dir);
  else
    filename = QFileDialog::getOpenFileName(0, caption, dir);

  filename = graph_dir.relativeFilePath(filename);

  if (filename == "")
    return;

  edt->setText(filename);
}

void MainWindow::choose_input_file(QLineEdit *edt, QString caption,
                                   QString dir) {
  choose_file(edt, caption, dir, false);
}

void MainWindow::choose_output_file(QLineEdit *edt, QString caption,
                                    QString dir) {
  choose_file(edt, caption, dir, true);
}

void MainWindow::select_input_extensions_file() {
  choose_input_file(inputExtensionsEdt, "Maximal Extensions Input",
                    "extensions");
}

void MainWindow::select_good_vert_file() {
  choose_output_file(goodVertEdt, "Good Vertex", "extensions");
}

void MainWindow::select_e_graph_file() {
  choose_output_file(eGraphEdt, "e-Graph", "extensions");
}

void MainWindow::select_good_sets_file() {
  choose_output_file(goodSetsEdt, "Good Sets", "extensions");
}

void MainWindow::select_max_ext_file() {
  choose_output_file(maxExtEdt, "Maximal Extensions", "extensions");
}

void MainWindow::select_input_cliques_file() {
  choose_input_file(inputCliquesEdt, "Maximal Cliques Input", "cliques");
}

void MainWindow::select_output_cliques_file() {
  choose_input_file(outputCliquesEdt, "Maximal Cliques Output", "cliques");
}

void MainWindow::select_input_isomorphism_file() {
  choose_input_file(inputIsomorphismEdt, "Isomorphism Graphs Input",
                    "isomorphisms");
}

void MainWindow::select_output_isomorphism_file() {
  choose_input_file(outputIsomorphismEdt, "Isomorphism Graphs Output",
                    "isomorphisms");
}

void MainWindow::view_goodvert() {
  FileView *view = new FileView(QString("extensions/") + goodVertEdt->text());
}

void MainWindow::view_egraph() {
  FileView *view = new FileView(QString("extensions/") + eGraphEdt->text());
}

void MainWindow::view_goodsets() {
  FileView *view = new FileView(QString("extensions/") + goodSetsEdt->text());
}

void MainWindow::view_maxext() {
  FileView *view = new FileView(QString("extensions/") + maxExtEdt->text());
}

void MainWindow::view_cliques() {
  FileView *view = new FileView(QString("cliques/") + outputCliquesEdt->text());
}

void MainWindow::view_classes() {
  FileView *view =
      new FileView(QString("isomorphisms/") + outputIsomorphismEdt->text());
}
void MainWindow::check() {}
